/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.perm.interceptor;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ApiResultUtils;
import com.kuaike.common.utils.ErrorCodeUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.dto.AccessBizInfo;
import com.kuaike.scrm.common.perm.dto.AccessUserInfo;
import com.kuaike.scrm.common.perm.service.AccessPermitService;
import com.kuaike.scrm.common.perm.utils.PermUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.ServletUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class ExternalAccessInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ExternalAccessInterceptor.class);
    private static final String TOKEN_KEY = "token";
    @Value(value="${spring.redis.externalRedisKey:%s:external:token:%s}")
    private String externalRedisKey;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${permission.prefix:}")
    private String prefix;
    @Autowired
    private AccessPermitService accessPermitService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LoginUtils.clear();
        LoginUtils.setSession(request.getSession());
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        boolean exist = LoginUtils.hasLoginNeedless(handler);
        if (exist) {
            return true;
        }
        String token = (String)StringUtils.defaultIfBlank((CharSequence)request.getHeader(TOKEN_KEY), (CharSequence)request.getParameter(TOKEN_KEY));
        if (StringUtils.isBlank((CharSequence)token)) {
            log.warn("token\u4e3a\u7a7a");
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        String redisKey = String.format(this.externalRedisKey, this.redisKeyPrefix, token);
        if (Boolean.FALSE.equals(this.redisTemplate.hasKey((Object)redisKey))) {
            log.warn("token redis key \u4e0d\u5b58\u5728:{}", (Object)redisKey);
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        HashOperations hash = this.redisTemplate.opsForHash();
        String sessionId = (String)hash.get((Object)redisKey, (Object)"sessionId");
        Long userId = Long.parseLong(hash.get((Object)redisKey, (Object)"userId").toString());
        if (Objects.isNull(sessionId)) {
            log.warn("\u5f53\u524d\u64cd\u4f5c\u7528\u6237sessionId\u4e3a\u7a7a:{}", (Object)redisKey);
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        if (Objects.isNull(userId)) {
            log.warn("\u5f53\u524d\u64cd\u4f5c\u7528\u6237userId\u4e3a\u7a7a:{}", (Object)redisKey);
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        LoginUtils.initRpcCurrentUser(sessionId, userId);
        String requestUri = request.getRequestURI();
        String actualUri = PermUtils.getPathWithPrefix(this.prefix, requestUri);
        log.debug("requestUri:{}", (Object)actualUri);
        if (StringUtils.isNotBlank((CharSequence)requestUri) && requestUri.endsWith("np")) {
            return true;
        }
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.debug("currentUserInfo:{}", (Object)currentUserInfo);
        if (null == currentUserInfo) {
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        if (Objects.isNull(currentUserInfo.getId())) {
            log.warn("\u5f53\u524d\u64cd\u4f5c\u7528\u6237userId\u4e3a\u7a7a");
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        AccessUserInfo user = this.accessPermitService.getAccessUser();
        if (Objects.isNull(user)) {
            log.warn("\u6839\u636euserId:{}\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f", (Object)userId);
            this.returnAjaxNotLoginResponse(request, response);
        }
        if (user != null && NumberUtils.INTEGER_ZERO.equals(user.getEnabled())) {
            log.warn("\u7528\u6237:{}\u5df2\u88ab\u7981\u7528", (Object)user.getId());
            this.returnAjaxNotLoginResponse(request, response);
            return false;
        }
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getWeworkUserId()) && NumberUtils.INTEGER_ZERO.equals(user.getIsAgentAuth())) {
            log.warn("weworkUser:{}", (Object)user.getWeworkUserId());
            this.returnAjaxBusinessCustomerForbid(response, "\u5f53\u524d\u7528\u6237\u672a\u6388\u6743,\u6682\u4e0d\u80fd\u767b\u5f55");
            return false;
        }
        AccessBizInfo businessCustomer = this.accessPermitService.getAccessBiz();
        if (Objects.isNull(businessCustomer)) {
            this.returnAjaxBusinessCustomerForbid(response, "\u5546\u6237\u4e0d\u5b58\u5728");
            return false;
        }
        boolean permit = this.accessPermitService.checkPermission(actualUri);
        log.debug("uri:{}, permit:{}", (Object)actualUri, (Object)permit);
        if (!permit) {
            this.returnNoPermissionResponse(response);
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        LoginUtils.clear();
        request.getSession().invalidate();
    }

    private void returnAjaxNotLoginResponse(HttpServletRequest request, HttpServletResponse response) {
        long code = ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)CommonErrorCode.NO_LOGIN);
        Map<String, String> map = Collections.singletonMap("redirectUrl", ServletUtil.getBasePath(request) + "/login?service=");
        response.setStatus(401);
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)new ApiResult(code, "\u7528\u6237\u672a\u767b\u5f55", map)));
    }

    private void returnNoPermissionResponse(HttpServletResponse response) {
        response.setStatus(403);
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)ApiResultUtils.error((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY)));
    }

    private void returnAjaxBusinessCustomerForbid(HttpServletResponse response, String msg) {
        response.setStatus(403);
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)ApiResultUtils.error((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, (String)msg)));
    }
}

