package com.kuaike.scrm.common.perm.service;

import java.util.List;
import java.util.Set;

/**
 * @author sunwen
 */
public interface UserRoleCommonService {

    /**
     * 获取管理部门集合(包含子部门)
     *
     * @return 部门id集合
     */
    Set<Long> getManageNodeIds();

    /**
     * 获取当前用户管理的部门id集合(包含用户自己)
     * @return
     */
    Set<Long> getManageUserIds();

    /**
     * 根据项目模块， 侧边菜单， 菜单名获取用于这些菜单角色的人员
     * 排除系统管理员
     * @param rootName
     * @param sideTabName
     * @param menuName
     * @return
     */
    List<Long> getMenuRoleUserIds(Long bizId, String rootName, String sideTabName, String menuName);
}
