/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.registrar;

import com.google.common.collect.Maps;
import com.kuaike.trace.config.EnableTraceId;
import com.kuaike.trace.interceptor.KafkaConsumerInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;

public class TraceIdScanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableTraceId.class.getName()));
        if (Objects.isNull(attributes)) {
            return;
        }
        String[] basePackage = attributes.getStringArray("basePackages");
        Enum webPrefix = attributes.getEnum("webPrefix");
        if (this.environment instanceof StandardEnvironment) {
            HashMap source = Maps.newHashMap();
            source.put("web.traceId.prefix", webPrefix.name());
            this.registerProperties((StandardEnvironment)this.environment, source);
        }
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        scanner.scan(basePackage);
    }

    private void registerProperties(StandardEnvironment environment, Map<String, Object> source) {
        String name = KafkaConsumerInterceptor.class.getName();
        source.put("spring.kafka.consumer.properties.interceptor.classes", name);
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addLast((PropertySource)new MapPropertySource("autoConfig", source));
    }
}

