/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.interceptor;

import com.kuaike.trace.utils.TraceIdUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TraceIdHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(TraceIdHandlerInterceptor.class);
    @Value(value="${web.traceId.prefix:}")
    private String traceIdPrefix;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            TraceIdUtils.generateTraceIdToRequest(request, TraceIdUtils.getTraceTypeByValue(this.traceIdPrefix));
        }
        catch (Exception e) {
            log.error("\u589e\u52a0traceId \u5f02\u5e38\uff1aerrorMsg:", (Throwable)e);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TraceIdUtils.removeTraceId();
    }
}

