/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.annotation.LoginNeedless;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

@Component
public class LoginUtils {
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    public static RedisTemplate<String, Object> REDIS_TEMPLATE;
    public static String REDIS_KEY_PREFIX;
    private static final String LOGIN_MOBILE = "LOGIN_MOBILE";
    private static final String LOGIN_ACCOUNT_ID = "LOGIN_ACCOUNT_ID";
    private static final String LOGIN_KEY = "SCRM_LOGIN_KEY_%s";
    public static final String APP_USER_NAME = "APP_USER_NAME:";
    public static final String APP_REQ_TOKEN = "APP_REQ_TOKEN:";
    private static final ThreadLocal<CurrentUserInfo> currentUser;
    private static final ThreadLocal<HttpSession> SESSION;

    @PostConstruct
    public void init() {
        log.info("Initialize LoginUtils: {}, {}", (Object)this.redisKeyPrefix, this.redisTemplate);
        REDIS_TEMPLATE = this.redisTemplate;
        REDIS_KEY_PREFIX = this.redisKeyPrefix;
    }

    public static void setCurrentUser(CurrentUserInfo user) {
        currentUser.set(user);
    }

    public static CurrentUserInfo getCurrentUser() {
        return currentUser.get();
    }

    public static Long getCurrentUserId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getId();
        }
        return null;
    }

    public static String getCurrentUserCorpId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getCorpId();
        }
        return null;
    }

    public static Long getCurrentUserBizId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getBizId();
        }
        return null;
    }

    public static void setSession(HttpSession httpSession) {
        SESSION.set(httpSession);
    }

    public static HttpSession getSession() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return SESSION.get();
        }
        return attributes.getRequest().getSession();
    }

    public static void clear() {
        currentUser.remove();
        SESSION.remove();
    }

    public static String getUserInfoKey(String redisKeyPrefix, Long userId) {
        return redisKeyPrefix + LoginUtils.getSessionId() + String.format(LOGIN_KEY, userId);
    }

    public static void initCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        Object cache = redisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
        redisTemplate.opsForValue().set((Object)LoginUtils.getSessionId(), (Object)LoginUtils.getLoginAccountId());
    }

    public static void initRpcCurrentUser(String sessionId, Long userId) {
        String key = LoginUtils.getUserInfoKey(REDIS_KEY_PREFIX, sessionId, userId);
        Object cache = REDIS_TEMPLATE.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
    }

    private static String getUserInfoKey(String redisKeyPrefix, String sessionId, Long userId) {
        return redisKeyPrefix + sessionId + String.format(LOGIN_KEY, userId);
    }

    public static void deleteCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        redisTemplate.delete((Object)key);
    }

    public static boolean hasLoginNeedless(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class type = handlerMethod.getBeanType();
        LoginNeedless loginNeedless = type.getAnnotation(LoginNeedless.class);
        if (loginNeedless == null) {
            loginNeedless = type.getSuperclass().getAnnotation(LoginNeedless.class);
        }
        if (loginNeedless == null) {
            loginNeedless = (LoginNeedless)handlerMethod.getMethodAnnotation(LoginNeedless.class);
        }
        return loginNeedless != null;
    }

    public static String getSessionId() {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            return session.getId();
        }
        return null;
    }

    public static Long getLoginAccountId() {
        Long userId = null;
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            userId = (Long)session.getAttribute(LOGIN_ACCOUNT_ID);
        }
        return userId;
    }

    public static void setLoginAccountId(Long userId) {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(LOGIN_ACCOUNT_ID, (Object)userId);
        }
    }

    public static void removeLoginAccountId() {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.removeAttribute(LOGIN_ACCOUNT_ID);
            session.removeAttribute(LOGIN_MOBILE);
        }
    }

    public static void setLoginMobile(String mobile) {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(LOGIN_MOBILE, (Object)mobile);
        }
    }

    public static String getLoginMobile() {
        String mobile = null;
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            mobile = (String)session.getAttribute(LOGIN_MOBILE);
        }
        return mobile;
    }

    public static String buildAppUserNameKey(String redisKeyPrefix, String username) {
        return redisKeyPrefix + APP_USER_NAME + username;
    }

    public static String buildAppReqTokenKey(String redisKeyPrefix, String reqToken) {
        return redisKeyPrefix + APP_REQ_TOKEN + reqToken;
    }

    static {
        currentUser = new InheritableThreadLocal<CurrentUserInfo>();
        SESSION = new InheritableThreadLocal<HttpSession>();
    }
}

