/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum QualitySenderType {
    WEWORK_USER(1, "\u6210\u5458"),
    WEWORK_CONTACT(2, "\u5ba2\u6237");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, QualitySenderType> MAP;

    private QualitySenderType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static QualitySenderType getByType(Integer type) {
        return MAP.get(type);
    }

    static {
        MAP = Arrays.stream(QualitySenderType.values()).collect(Collectors.toMap(QualitySenderType::getType, Function.identity()));
    }
}

