package com.kuaike.scrm.vip.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;
import java.util.UUID;


/**
 * 群成员信息
 */
@Data
public class GroupMemberInfo {
    private String avatar;
    /**
     * 昵称
     */
    private String nickname;

    /**
     * 微信号
     */
    private String weworkId;

    /**
     * 别名
     */
    private String alias;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 性别
     */
    private Integer sex;

    private String uuid; //上报时手动设置，消费时看使用的是谁上报的信息

    private String memberRemark;

    private Integer role;

    private Integer joinScene;

    private Long joinTime;

    private String name;

    private String operatorRemoteId;

    private String corpName;

    private String corpId;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GroupMemberInfo)) return false;
        GroupMemberInfo that = (GroupMemberInfo) o;
        return Objects.equals(weworkId, that.weworkId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(weworkId);
    }

    public void validate() {
        uuid = UUID.randomUUID().toString().replace("-", "");
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkId), "wechatId not null");
    }

}
