/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 群发企业客户状态
 * 
 * @title GroupSendContactStatus
 * @author yanmaoyuan
 * @date 2021年6月22日
 * @version 1.0
 * @see https://open.work.weixin.qq.com/api/doc/90000/90135/93338
 */
public enum GroupSendContactStatus implements EnumService {

    FAILED(-1, "发送失败"),

    NOT_SEND(0, "未送达，待成员确认发送"),

    SENT(1, "已送达"),

    NOT_FRIEND(2, "客户已不是好友"),

    LIMITED(3, "客户接收已达上限"),

    STOP_SEND(4, "手动停止发送");

    private final int value;
    private final String desc;

    GroupSendContactStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, GroupSendContactStatus> CACHE;

    private static final Map<String, GroupSendContactStatus> CACHE_DESC;

    static {
        CACHE = new HashMap<>();
        CACHE_DESC = new HashMap<>();
        for (GroupSendContactStatus e:values()) {
            CACHE.put(e.value, e);
            CACHE_DESC.put(e.desc, e);
        }
    }

    public static GroupSendContactStatus get(Integer value) {
        return CACHE.get(value);
    }

    public static GroupSendContactStatus getByDesc(String desc) {
        return CACHE_DESC.get(desc);
    }
}
