package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * @author Created by chenjiaqiang on 2022/01/04
 *
 **/
@Getter
public enum GoodsValidType {

    /**
     * 指定时间范围生效
     */
    COUPON_VALID_TYPE_TIME(1,"指定时间范围生效","COUPON_VALID_TYPE_TIME"),
    COUPON_VALID_TYPE_DAY(2,"生效天数","COUPON_VALID_TYPE_DAY")

    ;

    private final Integer type;
    private final String desc;
    private final String enDesc;

    GoodsValidType(Integer type, String desc, String enDesc){
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    private static final Map<Integer, GoodsValidType> MAP = Maps.newHashMap();
    private static final Map<String, GoodsValidType> EN_MAP = Maps.newHashMap();

    static {
        for (GoodsValidType e : values()) {
            MAP.put(e.type, e);
            EN_MAP.put(e.enDesc, e);
        }
    }

    public static boolean isExistByType(int type){
        return MAP.containsKey(type);
    }

    public static String getDescByType(int type) {
        return MAP.containsKey(type) ? MAP.get(type).getDesc() : null;
    }

    public static Integer getTypeByEnDesc(String enDesc){
        return EN_MAP.containsKey(enDesc)? EN_MAP.get(enDesc).getType():-1;
    }

    public static String getEnDescByType(int type){
        return MAP.containsKey(type) ? MAP.get(type).getEnDesc() : null;
    }
}
