package com.kuaike.scrm.common.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author lwl
 * @date 2025/8/8
 * @desc 网校定义的商品类型
 */
@Getter
public enum NetSchoolShopTypeEnum {
    COURSE(1, "普通课程"),
    CLASS(19, "班级"),
    CLASS_PACK(17, "课时包")
    ;

    private final int value;
    private final String desc;

    NetSchoolShopTypeEnum(int id, String name) {
        this.value = id;
        this.desc = name;
    }

    private static final Map<Integer, NetSchoolShopTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (NetSchoolShopTypeEnum item : NetSchoolShopTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static NetSchoolShopTypeEnum get(Integer status) {
        return CACHE.get(status);
    }
}