package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2021/12/24 上午11:27
 * content:
 */
public enum DynamicFormMoment implements EnumService {
    OPEN_FORM(1, "进入表单"),
    SUBMIT_FORM(2, "提交表单");

    DynamicFormMoment(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private final int value;
    private final String desc;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DynamicFormMoment> CACHE;

    static {
        CACHE = new HashMap<>();
        for (DynamicFormMoment e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static DynamicFormMoment get(int status) {
        return CACHE.get(status);
    }
}


