package com.kuaike.scrm.common.enums.voicecall;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chenjiaqiang
 * 语音外呼内容类型
 */
public enum VoiceContentTypeEnum implements EnumService {
    TEXT(1, "文本"),

    VOICE_URL(2, "语音文件"),

    VOICE_MATERIAL_ID(3, "语音素材")
    ;

    private final int value;
    private final String name;

    VoiceContentTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, VoiceContentTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (VoiceContentTypeEnum item : VoiceContentTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static VoiceContentTypeEnum get(Integer value) {
        return CACHE.get(value);
    }
}
