package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum QualitySenderType {
    WEWORK_USER(1, "成员"),
    WEWORK_CONTACT(2, "客户");

    private final Integer type;

    private final String desc;

    QualitySenderType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, QualitySenderType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(QualitySenderType::getType, Function.identity()));
    }

    public static QualitySenderType getByType(Integer type) {
        return MAP.get(type);
    }
}
