package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 会议观看类型 1直播 2回放
 */
public enum MeetingWatchType implements EnumService{
    LIVE(1,"直播"),
    PLAY_BACK(2,"回放");

    private final int value;
    private final String desc;

    MeetingWatchType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingWatchType> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (MeetingWatchType item : values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static MeetingWatchType get(int status) {
        return CACHE.get(status);
    }
}
