/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.constants;

/**
 * @author yanmaoyuan
 * @version 1.0
 * @title Conf
 * @date 2021年1月17日
 */
@SuppressWarnings("java:S1214")
public interface Conf {

    long FRONT_SESSION_TIMEOUT = 60L * 60 * 24 * 30;  //  30天

    String ROC_LOGIN_KEY = "ROC_LOGIN_KEY_%s";

    String ROC_LOING_USER_NAME = "ROC_LOING_USER_NAME";

    /**
     * SnsUserinfo的缓存过期时间，单位:秒
     */
    int SNS_CACHE_EXPIRE = 3600;

    /**
     * 设置的cookie名字
     */
    String SNS_USERINFO_TOKEN = "SNS_USERINFO_TOKEN";

    /**
     * pv/uv 上报时确定客户的cookie 名
     */
    String SNS_UNIQ_ID = "SNS_UNIQ_ID";

    int MAX_ROOM_COUNT = 300;

    /**
     * 单个成员最多客户数为50000
     */
    int MAX_CONTACT_COUNT = 50000;

    String CHANNEL_REGION_KEY_FORMAT = "channelId:{0}-regionInfoId:{1}";

    String EMPTY_SEND_WEWORK_USER_NUM = "emptyUserNum";

    String EMPTY_RECEIVE_ID = "emptyReceiverId";

    int ENLARGE_FACTOR = 10000;

    int SHOW_MAX_STAGE = 3;

    String DEFAULT_CHANNEL_NAME = "企业微信";

    /**
     * 用户昵称占位符
     */
    String FRIEND_FISSION_CONTACT_NICKNAME = "${nickname}";

    /**
     * 阶段一剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_1 = "${remainReward-1}";

    /**
     * 阶段二剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_2 = "${remainReward-2}";

    /**
     * 阶段三剩余奖品数量占位符
     */
    String FRIEND_FISSION_REMAIN_REWARD_3 = "${remainReward-3}";

    /**
     * 试用账号限制
     **/
    String TRAIL_ACCOUNT_LIMIT = "账号数量已达到上限，请联系企业管理员";

    /**
     * 正式账号限制
     **/
    String NORMAL_ACCOUNT_LIMIT = "账号数量已达到上限，请联系企业管理员";

    String QRCODE_TASK_MSG_PRE = "qrcodeSubTask";

    String QRCODE_TASK_STATE_PRE = "AD_";

    /**
     * 微信获客链接state
     */
    String WEWORK_CUSTOMER_ACQUISITION_STATE_PREFIX = "CA_";

    String WEWORK_CUSTOMER_ACQUISITION_SHARE_STATE_PREFIX = "CS_";

    String WEWORK_QRCODE_ALLOC_STATE_PREFIX = "WEWORK_ALLOC_";

    String NET_SCHOOL_FIRST_CODE = "27";

    String NET_SCHOOL_SECOND_CODE = "2701";

    String RADAR_QRCODE_PER = "RD_";

    String FILE_TYPE_MP4 = "mp4";

    /**
     * web端识别的语言格式
     */
    String FILE_SUFFIX_MP4 = ".mp4";

    String REQ_SOURCE = "req-source";

    String REQ_TOKEN = "req-token";

    String FREQUENTLY_PUSH_STR ="微信返回：消息发送频繁。为了您的账号安全，系统已经自动停止发送，如须再次发送，请手动点击一键重发";

    String UNKNOWN_ERROR_REMARK = "处理异常,原因未知";

    /**
     * 正式环境群消息分批发送size
     */
    int MESSAGE_SEND_CHATROOM_BATCH_SIZE_PROD = 300;

    String ORDER_CENTER_LOCK_PREFIX = "order-center:";

    String NET_SCHOOL_LOCK_PREFIX = "net-school:";

    /**
     * 多长时间可以撤回消息
     */
    int CAN_REVOKE_MESSAGE_DURATION_MINUTES = 2;
    /**
     * 撤回消息时间 110s, 预留10s给移动端
     **/
    int CAN_REVOKE_MESSAGE_DURATION_SECONDS = 110;

    String NET_SCHOOL_CONFIG_ERROR = "校区未配置支付商户，请先配置后，再录入订单";
}
