package com.kuaike.scrm.vip.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 群发消息重试类型
 */
public enum MessageSendRetryType {

    TASK(0, "消息Task表ID, 重发整个任务中失败的消息"),
    DETAIL(1, "消息detail表id，重发单条消息");

    private final Integer value;
    private final String desc;

    private static final Map<Integer, MessageSendRetryType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(MessageSendRetryType::getValue, Function.identity()));
    }

    public static MessageSendRetryType getType(Integer type) {
        return MAP.get(type);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    MessageSendRetryType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
