package com.kuaike.scrm.vip.dto.file;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/11/20 18:00
 */
@Data
public class WeworkFileDto {
    private String uniqueId;

    private String fileUrl;

    private String transcodeFileUrl;

    private String fileName;

    @JSONField(name="fileType")
    private int contentType;

    private String fileTypeStr;

    @JSONField(name="fileStatus")
    private int status;

    private String videoCover;

    public void initFileTypeStr(){
        if(StringUtils.isNotEmpty(this.fileName)){
            int index = this.fileName.lastIndexOf(".");
            if(index > -1 && index != this.fileName.length()-1){
                this.fileTypeStr = this.fileName.substring(index+1);
            }
        }
    }
}
