/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.dto.message;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MessageSyncDto {
    private String weworkId;
    private List<WeworkMessage> messageList;
    private String corpId;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkId), (Object)"weworkId not null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.messageList), (Object)"messageList not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.corpId), (Object)"corpId not null");
        this.messageList.forEach(t -> {
            t.setCorpId(this.corpId);
            t.setUpdateTime(new Date());
        });
    }

    public String getWeworkId() {
        return this.weworkId;
    }

    public List<WeworkMessage> getMessageList() {
        return this.messageList;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setWeworkId(String weworkId) {
        this.weworkId = weworkId;
    }

    public void setMessageList(List<WeworkMessage> messageList) {
        this.messageList = messageList;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageSyncDto)) {
            return false;
        }
        MessageSyncDto other = (MessageSyncDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$weworkId = this.getWeworkId();
        String other$weworkId = other.getWeworkId();
        if (this$weworkId == null ? other$weworkId != null : !this$weworkId.equals(other$weworkId)) {
            return false;
        }
        List<WeworkMessage> this$messageList = this.getMessageList();
        List<WeworkMessage> other$messageList = other.getMessageList();
        if (this$messageList == null ? other$messageList != null : !((Object)this$messageList).equals(other$messageList)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        return !(this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageSyncDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $weworkId = this.getWeworkId();
        result = result * 59 + ($weworkId == null ? 43 : $weworkId.hashCode());
        List<WeworkMessage> $messageList = this.getMessageList();
        result = result * 59 + ($messageList == null ? 43 : ((Object)$messageList).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        return result;
    }

    public String toString() {
        return "MessageSyncDto(weworkId=" + this.getWeworkId() + ", messageList=" + this.getMessageList() + ", corpId=" + this.getCorpId() + ")";
    }
}

