/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum GoodsValidType {
    COUPON_VALID_TYPE_TIME(1, "\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u751f\u6548", "COUPON_VALID_TYPE_TIME"),
    COUPON_VALID_TYPE_DAY(2, "\u751f\u6548\u5929\u6570", "COUPON_VALID_TYPE_DAY");

    private final Integer type;
    private final String desc;
    private final String enDesc;
    private static final Map<Integer, GoodsValidType> MAP;
    private static final Map<String, GoodsValidType> EN_MAP;

    private GoodsValidType(Integer type, String desc, String enDesc) {
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    public static boolean isExistByType(int type) {
        return MAP.containsKey(type);
    }

    public static String getDescByType(int type) {
        return MAP.containsKey(type) ? MAP.get(type).getDesc() : null;
    }

    public static Integer getTypeByEnDesc(String enDesc) {
        return EN_MAP.containsKey(enDesc) ? EN_MAP.get(enDesc).getType() : -1;
    }

    public static String getEnDescByType(int type) {
        return MAP.containsKey(type) ? MAP.get(type).getEnDesc() : null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    static {
        MAP = Maps.newHashMap();
        EN_MAP = Maps.newHashMap();
        for (GoodsValidType e : GoodsValidType.values()) {
            MAP.put(e.type, e);
            EN_MAP.put(e.enDesc, e);
        }
    }
}

