package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author louis
 * @date 2023/6/1
 */
public enum LicenseStatusEnum implements EnumService{

    UNBIND(1, "未绑定"),
    BINDING(2, "已绑定且有效"),
    OVERDUE(3, "已过期"),
    TO_TRANSFER(4, "待转移"),
    MERGED(5, "已合并"),
    TO_DOWNSTREAM(6, "已分配给下游"),
            ;



    private final int value;
    private final String desc;

    LicenseStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LicenseStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (LicenseStatusEnum item : LicenseStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static LicenseStatusEnum get(int value) {
        return CACHE.get(value);
    }
}
