/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.enums;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author yanmaoyuan
 * @version 1.0
 * @title WeworkSystemEnums
 * @date 2020年11月16日
 */
public enum WeworkSystemEnums {

    MANAGER(1, "scrm-manager"),

    APP(2, "scrm-app");

    private final int type;

    private final String name;

    private final String desc;

    private static final Map<Integer, WeworkSystemEnums> MAP;

    private static final Set<String> TYPES;

    static {
        TYPES = Arrays.stream(values()).map(WeworkSystemEnums::getName).collect(Collectors.toSet());
        MAP = Arrays.stream(values()).collect(Collectors.toMap(WeworkSystemEnums::getType, Function.identity()));
    }

    WeworkSystemEnums(int type, String name) {
        this(type, name, "");
    }

    WeworkSystemEnums(int type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WeworkSystemEnums getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(String system) {
        return TYPES.contains(system);
    }
}
