package com.kuaike.scrm.common.enums;


import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/6/4 3:09 下午
 */
public enum QueryType {

    DEFAULT(0,""),

    CONTACT(1, "联系人查询"),

    CHAT_ROOM(2, "群查询"),

    QRCODE(3, "活码查询");

    private final int type;

    private final String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    QueryType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, QueryType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(QueryType::getType, Function.identity()));
    }

    public static QueryType getByType(int type) {
        return MAP.get(type);
    }
}
