package com.kuaike.scrm.common.enums;

/**
 * author:  ljc
 * date:    2023/4/27
 * desc:    订单支付通知提醒人类型
 * 需要按位运算，新增注意取值
 */
public enum OrderNotifyTargetType {
    INVITE(1, "邀请人"),
    BIND(2, "绑定人"),
    DESIGNATE(4, "指定人");


    private final int value;
    private final String desc;

    OrderNotifyTargetType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean in(Integer value, OrderNotifyTargetType... type) {
        if (value != null && type != null && type.length > 0){
            for (OrderNotifyTargetType orderNotifyTargetType : type) {
                if ((orderNotifyTargetType.value & value) != 0) {
                    return true;
                }
            }
        }
        return false;
    }
}
