package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2021/12/22 下午5:43
 * content:
 */
public enum DynamicFormStatus implements EnumService {
    DRAFT(1, "草稿"),
    RELEASE(2, "已发布"),
    END(3, "已截止");

    DynamicFormStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private final int value;
    private final String desc;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DynamicFormStatus> CACHE;

    static {
        CACHE = new HashMap<>();
        for (DynamicFormStatus e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static DynamicFormStatus get(int status) {
        return CACHE.get(status);
    }
}
