/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum QualityBehaviorType {
    NONE(0, "none"),
    RED_PACKAGE(1, "\u53d1\u7ea2\u5305"),
    CARD(2, "\u53d1\u540d\u7247"),
    DEL_CONTACT(3, "\u5220\u9664\u597d\u53cb"),
    DEL_BY_CONTACT(4, "\u88ab\u597d\u53cb\u5220\u9664"),
    TIMEOUT_UNREPLY(5, "\u8d85\u65f6\u672a\u56de\u590d");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, QualityBehaviorType> MAP;

    private QualityBehaviorType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static QualityBehaviorType getByType(int type) {
        return MAP.get(type);
    }

    static {
        MAP = Arrays.stream(QualityBehaviorType.values()).collect(Collectors.toMap(QualityBehaviorType::getType, Function.identity()));
    }
}

