/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.event.context;

import java.util.Date;
import java.util.Set;

import lombok.Data;

/**
 * @title ReplyContext
 * @author yanmaoyuan
 * @date 2021年6月5日
 * @version 1.0
 */
@Data
public class ReplyContext {

    private String qyapiType;

    private String msgKey;

    private String msgType;

    private Long bizId;

    private String corpId;

    // 当收到第三方回调时，corpId保存明文corpId，authCorpId保存加密corpId
    private String authCorpId;

    private Integer agentId;

    private String chatId;

    private String weworkUserId;

    private String weworkUserNum;

    private String weworkUserName;

    private String contactId;

    private String state;

    private String welcomeCode;

    private boolean isPlanActive;

    private String nickname;// 客户昵称

    /**
     * 加好友的时候，图像
     */
    private String contactAvatar;

    /**
     * 是否通过广告推广中的企微名片来的
     */
    private boolean isAdQrcode;

    private boolean isRadar;

    /**
     * 是否是通过微信获客链接加的好友
     */
    private boolean isWeworkCustomerAcquisition;

    private Long planId;

    private String planName;

    private String planNum;

    private Integer planType;
 
    private Long planGroupId;

    private Long channelId;

    private Date timestamp;

    /**
     * 是否通过手机号批量加好友来的
     */
    private boolean isTelAddFriend;

    private String mobile;

    private Long taskDetailId;


    /**
     * 用于好友裂变
     * 
     * 标记该客户是通过哪个好友的二维码加的好友
     */
    private String pContactId;

    /**
     * 标记是否是新好友
     **/
    private boolean isNewCustomer;

    /**
     * 是否助力成功
     **/
    private boolean isFissionSuccess;

    /**
     * 活动是否已结束
     **/
    private boolean isFissionEnd;

    /**
     * 获取是否是草稿 1是 0否
     *
     * @return - 是否是草稿 1是 0否
     */
    private int isFissionDraft;

    /**
     * 获取是否删除: 1是 0否
     *
     * @return - 是否删除: 1是 0否
     */
    private int isFissionDeleted;
    /**
     * 获取是否被启用 1是 0否
     *
     * @return - 是否被启用 1是 0否
     */
    private int isFissionEnabled = 1;

    /**
     * 手机号批量加好友任务num
     */
    private String telAddFriendTaskNum;

    /**
     * 手机号批量加好友任务name
     */
    private String telAddFriendTaskName;

    private Set<String> existMemberIds;

    private Set<String> newMemberIds;


    private String acquisitionTagIds;
}