package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/5/31 4:48 下午
 */
public enum TelAddFriendStatus {
    /**
     * 待申请
     */
    TOBE_APPLY(0,"待添加"),

    APPLY_ING(1,"待通过"),

    SUCCESS(2, "已添加"),

    EXPIRE(3, "已过期"),

    FAILED(4, "已失败")

    ;

    private final int status;

    private final String desc;

    public int getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    TelAddFriendStatus(int type, String desc) {
        this.status = type;
        this.desc = desc;
    }

    private static final Map<Integer, TelAddFriendStatus> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(TelAddFriendStatus::getStatus, Function.identity()));
    }

    public static TelAddFriendStatus getTelAddFriendStatus(Integer value) {
        return MAP.get(value);
    }
}
