package com.kuaike.scrm.common.enums.addfriend;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum FilteredLeadsEnum implements EnumService {
    NOT_ADD(1, "被未选中成员绑定，不进行添加好友"),
    RANDOM_ADD(2, "被未选中成员绑定，随机添加好友");

    private final int type;
    private final String name;

    FilteredLeadsEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, FilteredLeadsEnum> CACHE;

    static {
        CACHE = new HashMap<>(5);
        for (FilteredLeadsEnum item : FilteredLeadsEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static FilteredLeadsEnum get(int status) {
        return CACHE.get(status);
    }
}
