package com.kuaike.scrm.common.enums.meeting;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2023/02/22
 * 直播带货授权模式
 **/
@Getter
public enum MeetingLiveDeliveryAuthMode {

    OFFICIAL_ACCOUNT(1,"公众号"),
    APPLET(2,"小程序")

    ;

    private final Integer value;
    private final String desc;

    MeetingLiveDeliveryAuthMode(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, MeetingLiveDeliveryAuthMode> MAP;

    static {
        MAP = Arrays.stream(MeetingLiveDeliveryAuthMode.values())
                .collect(Collectors.toMap(MeetingLiveDeliveryAuthMode::getValue, Function.identity()));
    }

    public static MeetingLiveDeliveryAuthMode getByMode(Integer value){
        return MAP.get(value);
    }

}
