package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OperatorResultStatus {

    WAITING(0, "待执行"),

    EXECUTING(1,"执行中"),

    FINISH(2,"完成"),

    FAIL(3,"异常退出")

    ;

    private Integer status;

    private String desc;

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    OperatorResultStatus(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static final Map<Integer, OperatorResultStatus> MAP;

    static {
        MAP = Arrays.stream(OperatorResultStatus.values()).collect(Collectors.toMap(OperatorResultStatus::getStatus, Function.identity()));
    }

    public static OperatorResultStatus getByStatus(Integer status) {
        return MAP.get(status);
    }
}
