/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum WeworkSystemEnums {
    MANAGER(1, "scrm-manager"),
    APP(2, "scrm-app");

    private final int type;
    private final String name;
    private final String desc;
    private static final Map<Integer, WeworkSystemEnums> MAP;
    private static final Set<String> TYPES;

    private WeworkSystemEnums(int type, String name) {
        this(type, name, "");
    }

    private WeworkSystemEnums(int type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WeworkSystemEnums getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(String system) {
        return TYPES.contains(system);
    }

    static {
        TYPES = Arrays.stream(WeworkSystemEnums.values()).map(WeworkSystemEnums::getName).collect(Collectors.toSet());
        MAP = Arrays.stream(WeworkSystemEnums.values()).collect(Collectors.toMap(WeworkSystemEnums::getType, Function.identity()));
    }
}

