/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum NoticeType {
    SYSTEM(0, "\u7cfb\u7edf\u6d88\u606f"),
    CRM_APPOINTMENT(1, "CRM\u9884\u7ea6\u6d88\u606f"),
    CLEAN_TASK_NOTICE(2, "\u6253\u626b\u4efb\u52a1\u5ba1\u6838\u6d88\u606f"),
    MAINTAIN_TASK_NOTICE(3, "\u7ef4\u4fee\u4efb\u52a1\u5ba1\u6838\u6d88\u606f"),
    CHECKOUT_TASK_NOTICE(4, "\u9000\u623f\u4efb\u52a1\u5ba1\u6838\u6d88\u606f");

    private final int type;
    private final String desc;
    private static final Map<Integer, NoticeType> MAP;

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private NoticeType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static NoticeType getByType(int type) {
        return MAP.get(type);
    }

    static {
        MAP = Arrays.stream(NoticeType.values()).collect(Collectors.toMap(NoticeType::getType, Function.identity()));
    }
}

