/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum JsMsgType {
    text,
    image,
    video,
    file,
    news,
    miniprogram,
    meeting,
    ffWords,
    voice,
    notice;

    private static final Set<String> CACHE;

    public static boolean contains(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return false;
        }
        return CACHE.contains(typeName.toLowerCase(Locale.getDefault()));
    }

    public static String getMsgName(JsMsgType typeName) {
        switch (typeName) {
            case text: {
                return "\u6587\u672c";
            }
            case image: {
                return "\u56fe\u7247";
            }
            case video: {
                return "\u89c6\u9891";
            }
            case file: {
                return "\u6587\u4ef6";
            }
            case news: {
                return "\u65b0\u95fb";
            }
            case miniprogram: {
                return "\u5c0f\u7a0b\u5e8f";
            }
            case meeting: {
                return "\u4f1a\u8bae";
            }
            case ffWords: {
                return "\u597d\u53cb\u88c2\u53d8";
            }
            case voice: {
                return "\u8bed\u97f3";
            }
            case notice: {
                return "\u7fa4\u516c\u544a";
            }
        }
        return "";
    }

    static {
        CACHE = Arrays.stream(JsMsgType.values()).map(a -> a.name().toLowerCase(Locale.getDefault())).collect(Collectors.toSet());
    }
}

