/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.model;

/**
 * @title Constants
 * @author yanmaoyuan
 * @date 2020年11月11日
 * @version 1.0
 */
public final class Constants {

    private Constants() {
        // Do not instance
    }

    /**
     * 最大群成员数量
     */
    public static final int CHAT_ROOM_MAX_MEMBER_COUNT = 500;

    /**
     * 联系人类型
     */
    public static final int CONTACT_TYPE_UNKNOWN   = 0;
    public static final int CONTACT_TYPE_YES       = 1;
    public static final int CONTACT_TYPE_NO        = 2;
    public static final int CONTACT_TYPE_WX        = 3;
    public static final int CONTACT_TYPE_MAYBE_WX  = 4;
    public static final int CONTACT_TYPE_VIP       = 5;
    public static final int CONTACT_TYPE_COMMUNITY = 6;
    public static final int CONTACT_TYPE_CORPGROUP = 7;

    /**
     * 会话类型
     */
    public static final int CONV_TYPE_CONTACT = 0; // 私聊
    public static final int CONV_TYPE_GROUP   = 1; // 群聊

    /**
     * 标识内部和外部会话。其中，内部指本企业内员工之间的会话，外部指包含企业外的联系人。
     */
    public static final int EXTERNAL_CONVERSATION = 1;// 外部会话
    public static final int INTERNAL_CONVERSATION = 2;// 内部会话

    /**
     * 常用消息类型
     */
    // 富文本消息，其中包含普通文本、圈人、QQ表情等
    public static final int CONTENT_TYPE_RICH_TEXT_0 = 0;
    public static final int CONTENT_TYPE_RICH_TEXT_2 = 2;
    // 图片
    public static final int CONTENT_TYPE_IMAGE_7   = 7;  // Image
    public static final int CONTENT_TYPE_IMAGE_14  = 14; // ImageCDN
    public static final int CONTENT_TYPE_IMAGE_101 = 101;// WechatImage
    // 动画表情
    public static final int CONTENT_TYPE_EMOTION_104 = 104;// WechatEmotion
    // 语音
    public static final int CONTENT_TYPE_VOICE_9  = 9; // Voice
    public static final int CONTENT_TYPE_VOICE_16 = 16;// VoiceCDN
    // 视频
    public static final int CONTENT_TYPE_VIDEO_5  = 5; // Video
    public static final int CONTENT_TYPE_VIDEO_17 = 17;// VideoCDN
    public static final int CONTENT_TYPE_VIDEO_23 = 23;// VideoFullCDN
    // 个人名片
    public static final int CONTENT_TYPE_PERSONAL_CARD_41 = 41;// PersonalCard
    // 链接卡片
    public static final int CONTENT_TYPE_LINK_13 = 13;// link
    // 文件
    public static final int CONTENT_TYPE_FILE_102 = 102;// WechatFile
    // 定位
    public static final int CONTENT_TYPE_LOCATION_6 = 6;// Location

    /**
     * 系统通知
     */
    // 修改群名
    public static final int CONTENT_TYPE_CHANGE_ROOM_NAME_1001 = 1001;
    // 入群
    public static final int CONTENT_TYPE_ADD_ROOM_MEMBER_1002 = 1002;
    // 退群
    public static final int CONTENT_TYPE_DELETE_ROOM_MEMBER_1003 = 1003;

    // 私聊时系统推送的一些灰字，诸如：
    // 你已添加了XXX，现在可以开始聊天了。
    // 以上是打招呼内容。
    // 此群为外部群，了解更多。
    // 这种消息没有appInfo、也没有senderId、senderName
    public static final int CONTENT_TYPE_TEXT_CONTROL_1011 = 1011;
}
