package com.kuaike.scrm.common.enums.alloc;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2021/10/25
 **/
@Getter
public enum AllocMemberType {

    /**
     * 分配客服
     */
    NORMAL(0,"分配客服"),

    BACKUP(1,"备用成员")


    ;

    private final int type;
    private final String desc;

    public static final Map<Integer, AllocMemberType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(AllocMemberType::getType, Function.identity()));
    }

    AllocMemberType(int type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public static AllocMemberType get(int type) {
        return MAP.get(type);
    }
}
