package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RadarType {

	FILE_PDF(0, "文件"),
	
	WX_GZH(1, "文章"),
	
	LINK(2, "链接");
	
	private final int value;
	
	private final String desc;
	
	RadarType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
	
	private static final Map<Integer, RadarType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(RadarType::getValue, Function.identity()));
    }

    public static RadarType getType(Integer value) {
        return MAP.get(value);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
