package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum NoticeType {

    SYSTEM(0, "系统消息"),

    CRM_APPOINTMENT(1, "CRM预约消息"),

    CLEAN_TASK_NOTICE(2, "打扫任务审核消息"),

    MAINTAIN_TASK_NOTICE(3, "维修任务审核消息"),

    CHECKOUT_TASK_NOTICE(4, "退房任务审核消息");

    private final int type;

    private final String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    NoticeType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, NoticeType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(NoticeType::getType, Function.identity()));
    }

    public static NoticeType getByType(int type) {
        return MAP.get(type);
    }
}
