package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author louis
 * @date 2023/6/2
 */
public enum LicenseTypeEnum implements EnumService{


    BASE_ACCOUNT(1, "基础帐号"),
    INTERWORKING_ACCOUNT(2, "互通帐号"),
    OFFICE_ACCOUNT(3, "办公帐号"),

            ;


    private final int value;
    private final String desc;

    LicenseTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LicenseStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (LicenseStatusEnum item : LicenseStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static LicenseStatusEnum get(int value) {
        return CACHE.get(value);
    }
}
