package com.kuaike.scrm.common.enums;

public enum SettingEnum {

    UNKNOWN(0, "unknow", "未知"),
    MOBILE_ENCRYPT(1, "mobileEncrypt", "手机号中间4位加密"),
    RECOMMEND_SETTING(2, "wiseRecommendNumPerDay", "推送设置"),
    SHARE_CUSTOMER(3,"shareCustomer","客资共享")
    ;

    public static SettingEnum getEnum(String enumName) {
        switch (enumName) {
            case "mobileEncrypt": return SettingEnum.MOBILE_ENCRYPT;
            case "wiseRecommendNumPerDay": return SettingEnum.RECOMMEND_SETTING;
            case "shareCustomer":
                return SettingEnum.SHARE_CUSTOMER;
            default: return SettingEnum.UNKNOWN;
        }
    }


    private int id;
    private String name;
    private String desc;

    SettingEnum(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }
}
