package com.kuaike.common.kafka.msg.content;

import com.google.common.base.Preconditions;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class RcLogUploadReq implements Serializable {

    private static final long serialVersionUID = 5898671990021814653L;
    /**
     * 群主wechatId
     */
    String wechatId;
    /**
     * 上报内容
     */
    List<ViolateChatRoomDto> list;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(wechatId),"wechatId is null or empty");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(list),"list is null or empty");
        for (ViolateChatRoomDto violateChatRoomDto : list) {
            violateChatRoomDto.validate();
        }
    }
}
