
package com.kuaike.common.enums.order;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 商品订单状态
 * @title OrderGoodsStatus
 * @desc TODO 
 * @author zhangbing
 * @date 2018年7月25日
 * @version 1.0
 */
public enum OrderGoodsStatus {
    
    UNFINISHED(1, "未结课"),

    FINISHED(2, "已结课");
    
    private int status;
    private String label;
    
    private OrderGoodsStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }
    
    private static Map<Integer, OrderGoodsStatus> cache;
    
    static {
        cache = Maps.newHashMap();
        for (OrderGoodsStatus goodsStatus : OrderGoodsStatus.values()) {
            cache.put(goodsStatus.getStatus(), goodsStatus);
        }
    }

    public int getStatus() {
    
        return status;
    }

    public void setStatus(int status) {
    
        this.status = status;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public static OrderGoodsStatus get(int status) {
        return cache.get(status);
    }
}

    