package com.kuaike.common.enums;

import com.google.common.collect.Maps;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * 消息类别
 * 1-文本
 *
 * @author: chencs
 * @date: 2019/4/18 14:51
 */
public enum WechatMsgType {

    //========以下为android定义消息类型 start========
    TEXT(1, "文本"),
    IMAGE(3, "图片"),
    VOICE(34, "语音"),
    VOICE_CALL(64, "语音通话"),
    BUSINESS_CARD(42, "名片"),
    VIDEO(43, "视频"),
    LOCATION(48, "定位"),
    FILE(49, "文件"),
    TIPS(10000, "提示"),
    SYSTEM(10002, "提示"),
    TRANSFER(419430449, "转账"),
    RED_PACKET(436207665, "红包"),
    WECHAT_SYSTEM(570425393, "系统"),
    WECHAT_SYSTEM_2(603979825, "系统"),
    LINK_CARD(495, "链接卡片"),
    MINI_PROGRAM(523, "小程序"),
    MINI_PROGRAM2(526, "小程序"),
    GIF(47, "动图"),
    JIX_LONG(805306417, "接龙"),
    CHANNELS(541, "视频号"),
    //========以下为android定义消息类型 end========

    //========以下为manager项目自定义类型 start========
    REVOKE(910001, "撤回"),
    RESULT_FAIL(910002, "失败"),
    GROUP_NOTICE(910003,"群公告"),

    JOIN_GROUP_CARD(103, "加群卡片"),
    Ignore(-1, "暂不支持类型")
    //========以下为manager项目自定义类型 end========
    ;

    private Integer value;
    private String desc;

    private static Map<Integer, WechatMsgType> map = Maps.newHashMap();

    static {
        for (WechatMsgType type : WechatMsgType.values()) {
            map.put(type.value, type);
        }
    }

    public static WechatMsgType getType(Integer type) {
        WechatMsgType wechatMsgType = map.get(type);
        if (Objects.isNull(wechatMsgType)) {
            wechatMsgType = WechatMsgType.Ignore; //fix 不支持类型报空指针
        }
        return wechatMsgType;
    }

    public static Integer getValueByDesc(String desc) {
        for (WechatMsgType type : WechatMsgType.values()) {
            if (desc.equals(type.getDesc()))
                return type.getValue();
        }
        return null;
    }

    public static Set<Integer> allValue() {
        return map.keySet();
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    WechatMsgType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
