package com.kuaike.common.enums;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class EnumConstant implements Serializable {

	private static final long serialVersionUID = -7504557678928058019L;

	private int value;

	private String desc;

	public static EnumConstant from(EnumService service) {
		if (service == null) {
			return null;
		}
		return new EnumConstant(service.getValue(), service.getDesc());
	}

}
