package com.kuaike.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 方法权限注解
 * @author shanyu
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface MethodPermission {
  /**
   * 接口名
   * @return
   */
  String name() default "";
  
  /**
   * 接口权限编号
   * @return
   */
  long permission();
  
  /**
   * 接口描述
   * @return
   */
  String desc() default "";
}
