/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public enum WechatMsgType {
    TEXT(1, "\u6587\u672c"),
    IMAGE(3, "\u56fe\u7247"),
    VOICE(34, "\u8bed\u97f3"),
    VOICE_CALL(64, "\u8bed\u97f3\u901a\u8bdd"),
    BUSINESS_CARD(42, "\u540d\u7247"),
    VIDEO(43, "\u89c6\u9891"),
    LOCATION(48, "\u5b9a\u4f4d"),
    FILE(49, "\u6587\u4ef6"),
    TIPS(10000, "\u63d0\u793a"),
    SYSTEM(10002, "\u63d0\u793a"),
    TRANSFER(419430449, "\u8f6c\u8d26"),
    RED_PACKET(436207665, "\u7ea2\u5305"),
    WECHAT_SYSTEM(570425393, "\u7cfb\u7edf"),
    WECHAT_SYSTEM_2(603979825, "\u7cfb\u7edf"),
    LINK_CARD(495, "\u94fe\u63a5\u5361\u7247"),
    MINI_PROGRAM(523, "\u5c0f\u7a0b\u5e8f"),
    MINI_PROGRAM2(526, "\u5c0f\u7a0b\u5e8f"),
    GIF(47, "\u52a8\u56fe"),
    JIX_LONG(0x30000031, "\u63a5\u9f99"),
    CHANNELS(541, "\u89c6\u9891\u53f7"),
    REVOKE(910001, "\u64a4\u56de"),
    RESULT_FAIL(910002, "\u5931\u8d25"),
    GROUP_NOTICE(910003, "\u7fa4\u516c\u544a"),
    JOIN_GROUP_CARD(103, "\u52a0\u7fa4\u5361\u7247"),
    Ignore(-1, "\u6682\u4e0d\u652f\u6301\u7c7b\u578b");

    private Integer value;
    private String desc;
    private static Map<Integer, WechatMsgType> map;

    public static WechatMsgType getType(Integer type) {
        WechatMsgType wechatMsgType = map.get(type);
        if (Objects.isNull((Object)wechatMsgType)) {
            wechatMsgType = Ignore;
        }
        return wechatMsgType;
    }

    public static Integer getValueByDesc(String desc) {
        for (WechatMsgType type : WechatMsgType.values()) {
            if (!desc.equals(type.getDesc())) continue;
            return type.getValue();
        }
        return null;
    }

    public static Set<Integer> allValue() {
        return map.keySet();
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private WechatMsgType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    static {
        map = Maps.newHashMap();
        for (WechatMsgType type : WechatMsgType.values()) {
            map.put(type.value, type);
        }
    }
}

