/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.dto.resp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Node
implements Serializable {
    public static final int NAME_SIZE = 3;
    public static final String SEPARATE = "-";
    public static final int DEEPEST_LEVEL = 10;
    private static final long serialVersionUID = 7052759963336265589L;
    private long id;
    private List<Long> ids;
    private Long pid;
    private int level;
    private Long type;
    private String num;
    private String code;
    private String name;
    private List<String> names;
    private List<Node> children;
    private Set<Long> posterityIds;
    private int isDel;
    private String fullName;
    private String sysCode;

    public static String getFullNodeIds(Node node) {
        if (CollectionUtils.isEmpty(node.getIds())) {
            return "";
        }
        return StringUtils.join(node.getIds(), (String)",") + ",";
    }

    public String getFullName() {
        this.fullName = Node.getFullName(this);
        return this.fullName;
    }

    public static List<String> getFullNodeIdsList(List<Long> ids, Map<Long, Node> nodeMap) {
        ArrayList list = Lists.newArrayList();
        for (Long id : ids) {
            Node node = nodeMap.get(id);
            if (node == null) continue;
            list.add(Node.getFullNodeIds(node));
        }
        return list;
    }

    public static Node getNodeWithoutChildren(Long nodeId, Map<Long, Node> nodeMap) {
        Node node = nodeMap.get(nodeId);
        if (node != null) {
            Node result = new Node();
            result.setId(node.getId());
            result.setNum(node.getNum());
            result.setCode(node.getCode());
            result.setType(node.getType());
            result.setIds(node.getIds());
            result.setLevel(node.getLevel());
            result.setName(node.getName());
            result.setNames(node.getNames());
            result.setPid(node.getPid());
            return result;
        }
        return null;
    }

    public static boolean isPosterity(Long id, List<Long> ids, Map<Long, Node> nodeMap) {
        for (Long pid : ids) {
            Set<Long> posterityIds = Node.getPosterityIds(pid, nodeMap);
            if (!posterityIds.contains(pid)) continue;
            return true;
        }
        return false;
    }

    public static String getFullName(Node node) {
        if (CollectionUtils.isEmpty(node.getNames())) {
            return "";
        }
        int size = node.getNames().size();
        if (node.getNames().size() > 3) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getNames().get(size - 3)).append(SEPARATE).append(node.getNames().get(size - 2)).append(SEPARATE).append(node.getNames().get(size - 1));
            return builder.toString();
        }
        return StringUtils.join(node.getNames(), (String)SEPARATE);
    }

    public static Map<Long, Node> buildNodeMap(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Maps.newHashMap();
        }
        HashSet rootIds = Sets.newHashSet();
        Map<Long, Node> map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (Node node : nodes) {
            if (map.containsKey(node.getPid())) {
                Node parent = map.get(node.getPid());
                if (parent.getChildren() == null) {
                    parent.setChildren(Lists.newArrayList());
                }
                parent.getChildren().add(node);
                continue;
            }
            rootIds.add(node.getId());
        }
        Node.buildIdAndNames(map, rootIds);
        return map;
    }

    private static void buildIdAndNames(Map<Long, Node> nodeMap, Set<Long> rootIds) {
        HashSet dealedIds = Sets.newHashSet();
        ArrayList tmpList = Lists.newArrayList();
        for (Long rootId : rootIds) {
            Node node = nodeMap.get(rootId);
            node.setIds(Lists.newArrayList((Object[])new Long[]{node.getId()}));
            node.setNames(Lists.newArrayList((Object[])new String[]{node.getName()}));
            dealedIds.add(rootId);
            if (!CollectionUtils.isNotEmpty(node.getChildren())) continue;
            for (Node children : node.getChildren()) {
                if (dealedIds.contains(children.getId()) || tmpList.contains(children.getId())) continue;
                tmpList.add(children.getId());
            }
        }
        while (CollectionUtils.isNotEmpty((Collection)tmpList)) {
            Long nodeId = (Long)tmpList.remove(0);
            Node node = nodeMap.get(nodeId);
            Node pNode = nodeMap.get(node.getPid());
            node.setIds(Lists.newArrayList());
            node.setNames(Lists.newArrayList());
            node.getIds().addAll(pNode.getIds());
            node.getIds().add(node.getId());
            node.getNames().addAll(pNode.getNames());
            node.getNames().add(node.getName());
            dealedIds.add(nodeId);
            if (!CollectionUtils.isNotEmpty(node.getChildren())) continue;
            for (Node children : node.getChildren()) {
                if (dealedIds.contains(children.getId()) || tmpList.contains(children.getId())) continue;
                tmpList.add(children.getId());
            }
        }
    }

    private static void buildIdAndNames(Node node, List<Long> parentIds, List<String> parentNames) {
        ArrayList ids = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        node.setIds(ids);
        node.setNames(names);
        if (parentIds != null) {
            ids.addAll(parentIds);
            names.addAll(parentNames);
        }
        ids.add(node.getId());
        names.add(node.getName());
        if (CollectionUtils.isNotEmpty(node.getChildren())) {
            for (Node child : node.getChildren()) {
                Node.buildIdAndNames(child, ids, names);
            }
        }
    }

    public static List<Node> buildNodeTrees(List<Node> nodes) {
        ArrayList nodeTrees = Lists.newArrayList();
        if (CollectionUtils.isEmpty(nodes)) {
            return nodeTrees;
        }
        Map map = nodes.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (Node node : nodes) {
            if (!map.containsKey(node.getPid())) {
                nodeTrees.add(node);
                continue;
            }
            Node parent = (Node)map.get(node.getPid());
            if (parent.getChildren() == null) {
                parent.setChildren(Lists.newArrayList());
            }
            parent.getChildren().add(node);
        }
        for (Node node : nodes) {
            if (map.containsKey(node.getPid())) continue;
            Node.buildIdAndNames(node, null, null);
        }
        return nodeTrees;
    }

    public static Set<Long> getPosterityIds(Long nodeId, Map<Long, Node> nodeMap) {
        HashSet nodeIds = Sets.newHashSet();
        nodeIds.add(nodeId);
        Node node = nodeMap.get(nodeId);
        if (node != null) {
            nodeIds.add(nodeId);
            if (CollectionUtils.isNotEmpty(node.getChildren())) {
                for (Node child : node.getChildren()) {
                    Node.getPosterityIds(nodeIds, child.getId(), nodeMap, 1);
                }
            }
        }
        return nodeIds;
    }

    private static void getPosterityIds(Set<Long> nodeIds, Long nodeId, Map<Long, Node> nodeMap, int level) {
        Node node = nodeMap.get(nodeId);
        if (node != null) {
            nodeIds.add(nodeId);
            if (level == 10) {
                return;
            }
            if (CollectionUtils.isNotEmpty(node.getChildren())) {
                for (Node child : node.getChildren()) {
                    Node.getPosterityIds(nodeIds, child.getId(), nodeMap, level + 1);
                }
            }
        }
    }

    public static void main(String[] args) {
        ArrayList nodeLists = Lists.newArrayList();
        Node node1 = new Node();
        node1.setId(1L);
        node1.setPid(0L);
        node1.setName("\u8282\u70b9\u4e00");
        Node node2 = new Node();
        node2.setId(2L);
        node2.setPid(1L);
        node2.setName("\u8282\u70b9\u4e8c");
        Node node3 = new Node();
        node3.setId(3L);
        node3.setPid(2L);
        node3.setName("\u8282\u70b9\u4e09");
        nodeLists.add(node1);
        nodeLists.add(node2);
        nodeLists.add(node3);
        System.out.println(Node.buildNodeMap(nodeLists));
    }

    public long getId() {
        return this.id;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public Long getPid() {
        return this.pid;
    }

    public int getLevel() {
        return this.level;
    }

    public Long getType() {
        return this.type;
    }

    public String getNum() {
        return this.num;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public Set<Long> getPosterityIds() {
        return this.posterityIds;
    }

    public int getIsDel() {
        return this.isDel;
    }

    public String getSysCode() {
        return this.sysCode;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public void setPosterityIds(Set<Long> posterityIds) {
        this.posterityIds = posterityIds;
    }

    public void setIsDel(int isDel) {
        this.isDel = isDel;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getIsDel() != other.getIsDel()) {
            return false;
        }
        Long this$pid = this.getPid();
        Long other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Long this$type = this.getType();
        Long other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        List<Long> this$ids = this.getIds();
        List<Long> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<Node> this$children = this.getChildren();
        List<Node> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        Set<Long> this$posterityIds = this.getPosterityIds();
        Set<Long> other$posterityIds = other.getPosterityIds();
        if (this$posterityIds == null ? other$posterityIds != null : !((Object)this$posterityIds).equals(other$posterityIds)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$sysCode = this.getSysCode();
        String other$sysCode = other.getSysCode();
        return !(this$sysCode == null ? other$sysCode != null : !this$sysCode.equals(other$sysCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getIsDel();
        Long $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Long $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        List<Long> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<Node> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        Set<Long> $posterityIds = this.getPosterityIds();
        result = result * 59 + ($posterityIds == null ? 43 : ((Object)$posterityIds).hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $sysCode = this.getSysCode();
        result = result * 59 + ($sysCode == null ? 43 : $sysCode.hashCode());
        return result;
    }

    public String toString() {
        return "Node(id=" + this.getId() + ", ids=" + this.getIds() + ", pid=" + this.getPid() + ", level=" + this.getLevel() + ", type=" + this.getType() + ", num=" + this.getNum() + ", code=" + this.getCode() + ", name=" + this.getName() + ", names=" + this.getNames() + ", children=" + this.getChildren() + ", posterityIds=" + this.getPosterityIds() + ", isDel=" + this.getIsDel() + ", fullName=" + this.getFullName() + ", sysCode=" + this.getSysCode() + ")";
    }
}

