package com.kuaike.common.kafka.msg.content;

import com.google.common.base.Preconditions;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class ViolateChatRoomDto implements Serializable {

    private static final long serialVersionUID = 8069482656352327850L;
    /**
     * 触发的群
     */
    String chatRoomId;

    /**
     * 生效的风控方案ID
     */
    Long planId;

    /**
     * 风控方案版本
     */
    Long version;

    /**
     * 违规的群成员wechatId
     */
    List<String> memberWechatIds;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(chatRoomId),"chatRoomId is null or empty");
        Preconditions.checkArgument(planId!=null,"planId is null");
        Preconditions.checkArgument(version!=null,"version");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(memberWechatIds),"memberWechatIds is null or empty");
    }
}
