/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.kuaike.common.kafka.msg.content.RcChatroomUpload;
import com.kuaike.common.kafka.msg.content.RcLogUploadReq;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SkyCommonMsgType {
    NICKNAME_VIOLATION_UPLOAD(100, "\u7fa4\u6635\u79f0\u8fdd\u89c4\u4e0a\u62a5", RcLogUploadReq.class.getName()),
    WECHAT_CHAT_ROOM_ADDED(101, "\u65b0\u589e\u7fa4\u4e0a\u62a5", RcChatroomUpload.class.getName());

    private int type;
    private String desc;
    private String contentClass;
    private static final Map<Integer, SkyCommonMsgType> MAP;
    private static final Set<Integer> typeSet;

    private SkyCommonMsgType(int type, String desc, String contentClass) {
        this.type = type;
        this.desc = desc;
        this.contentClass = contentClass;
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SkyCommonMsgType getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(int type) {
        return typeSet.contains(type);
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(SkyCommonMsgType.values()).collect(Collectors.toMap(SkyCommonMsgType::getType, Function.identity())));
        typeSet = ImmutableSet.copyOf((Collection)Arrays.stream(SkyCommonMsgType.values()).map(a -> a.getType()).collect(Collectors.toSet()));
    }
}

