package com.kuaike.skynet.manager.common.dto;

import com.kuaike.skynet.manager.common.dto.resp.UserRoleRespDto;
import com.kuaike.common.dto.resp.Node;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 当前用户登录信息
 *
 * @author: chencs
 * @date: 2019/4/11 15:20
 */
@Data
public class CurrentUserInfo implements Serializable {

    private static final long serialVersionUID = 1872319669183541525L;

    private Long id;    // 用户表自增主键id
    private Long businessCustomerId; // 所属商户id
    private String businessCustomerName; // 所属商户名称
    private String defaultDomain;   // 系统为商户生成的默认子域名，用于访问知识库
    private String userDomain;      // 商户自定义子域名，用于访问知识库
    private String loginName;   // 登录名
    private String chineseName; // 中文名
    private String avatar;      // 头像

    private Long staffId;   // 华图员工id

    private List<UserRoleRespDto> roles;    // 所有角色
    private UserRoleRespDto curRole;    // 当前角色

    private Map<Integer, Long> permissions;    // 当前权限集合

    private Long userNodeId;    // 用户所在部门的node_id

    private List<Long> nodeIds;     // 用户所管理部门及其子部门的node_id

    private List<Node> nodes;   // 用户所管理部门

    private String userType;        // 用户类型：1-平台，2-商户
    
    private Boolean enableCas;

    private String sessionId;       // sessionId, 前端统计使用
}
