
package com.kuaike.common.enums.order;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 支付状态
 * @title PayStatus
 * @desc TODO 
 * @author zhangbing
 * @date 2018年7月25日
 * @version 1.0
 */
public enum PayStatus {
    
    UN_PAY(1, "待支付"), PAY(2, "已支付"), TIMEOUT(3, "超时未支付");

    private int status;
    private String label;
    
    private PayStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    private static Map<Integer, PayStatus> cache;
    
    static {
        cache = Maps.newHashMap();
        for (PayStatus payStatus : PayStatus.values()) {
            cache.put(payStatus.getStatus(), payStatus);
        }
    }
    
    public int getStatus() {
    
        return status;
    }

    public void setStatus(int status) {
    
        this.status = status;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public static PayStatus get(int status) {
        return cache.get(status);
    }
}

    